
#|________________________________________________________________________
 |
 | Cluster Analysis plugin loading function
 |________________________________________________________________________
 |#


(setf *clus-plugin-path*  (strcat *plugin-path* "clustplg" *separator*))
(let ((menu-item-title "Cluster Analysis")
      (tool-name "Clstr")
      (model-prefix "Cls")
      (ok-data-types '("multivariate" "crosstabs" "general"))
      (ok-variable-types '(numeric)))
  (send *vista* :install-plugin tool-name menu-item-title ok-data-types)
  (defun cluster-analysis 
    (&key
     (linkage "single")
     (proximity "Euclidean")
     (data   *current-data*)
     (title  menu-item-title)
     (name   tool-name)
     (dialog t)) 

    "Args: &key linkage proximity data title name dialog
ViSta Cluster Analysis Plugin function to compute clusters in multivariate data. Uses an agglomerative nesting technique. Data must be multivariate. Linkage is one of: average, centroid, ward, gower, weighted, single, complete. Proximity is one of: Euclidean, Std-euclidean, Sq-euclidean, Cityblock, Mahalanobis, cosine, Correlation"
    (princ "; CopyRt: Cluster Analysis Code Copyright (c) 1998-2002, by Chad Petty,  Huh Moon Yul, Lee Kyungmi, and Forrest W. Young")
    (send clus-plugin-object-proto :new
	  linkage proximity
          menu-item-title tool-name model-prefix ok-data-types 
          data title name dialog ok-variable-types)
    ) ;end of constructor function
  (load (strcat *clus-plugin-path* "clusplg1"))
  ) ;end of let statement
